//
//  ContentView.swift
//  death_app Watch App
//
//  Created by Richard Brown on 16/09/2025.
//

import SwiftUI

/// Main content view for the death app with medical disclaimer compliance
/// Implements App Store-compliant disclaimer flow before app access
struct ContentView: View {
    @StateObject private var disclaimerService = DisclaimerService()
    @State private var isNavigatingToCalculation = false
    
    var body: some View {
        NavigationStack {
            if disclaimerService.hasAcceptedDisclaimer {
                // Main app content - placeholder for now
                VStack {
                    Image(systemName: "heart.fill")
                        .font(.largeTitle)
                        .foregroundColor(.red)
                    
                    Text("Life Expectancy Calculator")
                        .font(.headline)
                        .fontWeight(.bold)
                        .multilineTextAlignment(.center)
                    
                    Text("Entertainment & Educational Purpose Only")
                        .font(.caption)
                        .foregroundColor(.secondary)
                        .multilineTextAlignment(.center)
                        .padding(.top, 2)
                    
                    Spacer()
                    
                    Button(action: {
                        print("Start Calculation button tapped")
                        isNavigatingToCalculation = true
                    }) {
                        Text("Start Calculation")
                            .frame(maxWidth: .infinity)
                            .padding()
                            .background(Color.blue)
                            .foregroundColor(.white)
                            .cornerRadius(8)
                    }
                    .padding(.horizontal)
                    .sheet(isPresented: $isNavigatingToCalculation) {
                        LifeClockView()
                    }
                    
                    Button(action: {
                        disclaimerService.resetDisclaimer()
                    }) {
                        Text("View Medical Disclaimer")
                            .font(.caption)
                            .foregroundColor(.secondary)
                    }
                    .padding(.top, 8)
                }
                .padding()
            } else {
                // Show disclaimer before app access
                DisclaimerView(hasAcceptedDisclaimer: $disclaimerService.hasAcceptedDisclaimer)
            }
        }
        .environmentObject(disclaimerService)
    }
}

#Preview {
    ContentView()
}
